from typeguard import typechecked
from typing import Any


@typechecked
def filter_dict(dct: Any, keys: list, accept_none: bool = False) -> dict:
    """Returns a dict filtered to the given keys (if they exist) and optionally ignores None"""
    if isinstance(dct, dict):
        return {k: v for k, v in dct.items() if k in keys and (accept_none or v is not None)}
    return {}
