import logging
import sys

from functools import wraps

TIME_UNITS = {
    "d": "days",
    "s": "seconds",
    "us": "microseconds",
    "ms": "milliseconds",
    "m": "minutes",
    "h": "hours",
    "w": "weeks",
}

DEFAULT_LOGGER = None


def get_logger(new_logger: bool = False):
    global DEFAULT_LOGGER
    if new_logger or not DEFAULT_LOGGER:
        log_handler = logging.StreamHandler(sys.stdout)
        log_handler.setFormatter(
            logging.Formatter("%(asctime)s [%(levelname)s] [%(filename)s:%(lineno)d] %(message)s")
        )
        DEFAULT_LOGGER = logging.getLogger("defaultLogger")
        DEFAULT_LOGGER.addHandler(log_handler)
        DEFAULT_LOGGER.setLevel(logging.DEBUG)
    return DEFAULT_LOGGER


def log_it(func) -> None:
    @wraps(func)
    def __call__(*args, **kwargs):
        logger = DEFAULT_LOGGER
        if (
            len(args) > 0
            and isinstance(args[0], object)
            and isinstance(getattr(args[0], "_logger", None), logging.Logger)
        ):
            logger = args[0]._logger
        if logger:
            logger.debug(f"-- {func.__module__}.{func.__qualname__}(args={args},kwargs={kwargs} --")
        return func(*args, **kwargs)

    return __call__
