from typing import Optional

import boto3


def get_user_email_from_aws(session: Optional[boto3.Session] = None) -> str:
    """
    Retrieve the email address of the current user from their AWS credentials.

    Parameters
    ----------
    session : boto3.Session, optional
        A boto3 Session to use for AWS API calls. If not provided, a new session will be created.

    Returns
    -------
    str
        The email address extracted from the `UserId` field of the STS get_caller_identity response.
    """
    session = session or boto3.Session()
    return session.client("sts").get_caller_identity()["UserId"].split(":")[-1]
