def is_time_key(key: str) -> bool:
    '''Returns whether or not a dictionary key is an accepted time key'''
    '''Case insensitive and ignores leading/trailing whitespace'''
    return isinstance(key, str) and key.lower().strip() == 'time'


def is_version_key(key: str) -> bool:
    '''Returns whether or not a dictionary key is an accepted version key'''
    '''Case insensitive and ignores leading/trailing whitespace'''
    return isinstance(key, str) and key.lower().strip() == 'version'
