import logging
import sys

from functools import wraps


DEFAULT_LOG_HANDLER = logging.StreamHandler(sys.stdout)
DEFAULT_LOG_HANDLER.setFormatter(logging.Formatter(
    "%(asctime)s [%(levelname)s] [%(filename)s:%(lineno)d] %(message)s"
))
DEFAULT_LOGGER = logging.getLogger('defaultLogger')
DEFAULT_LOGGER.addHandler(DEFAULT_LOG_HANDLER)
DEFAULT_LOGGER.setLevel(logging.DEBUG)


def log_it(func) -> None:
    @wraps(func)
    def __call__(*args, **kwargs):
        logger = DEFAULT_LOGGER
        if (
            len(args) > 0 and
            isinstance(args[0], object) and
            isinstance(getattr(args[0], '_logger', None), logging.Logger)
        ):
            logger = args[0]._logger
        logger.debug(
            f'-- {func.__module__}.{func.__qualname__}(args={args},kwargs={kwargs} --'
        )
        return func(*args, **kwargs)
    return __call__
